<?php
# Writen by James Flynnn (https://jamespflynn.com) - You may use this with attribution.
ini_set('display_errors', 1);
ini_set('max_execution_time', 90);

$details 	= urldecode($_GET['details']);
$transaction	= urldecode($_GET['transaction']); 
$zeros 		= urldecode($_GET['zeros']); 
$maxTries 	= 100000000;
$end		= "<br/>\n";
$lead 		= str_pad('', $zeros, "0");

echo "Attempting to Solve Puzzle. <br/>Number of Leading Zeros Required: $zeros $end $end";

for ( $nonce = 1; $nonce <= $maxTries; $nonce++ )
{
	$hash = hash('sha256', $transaction . $nonce);
	$start = substr($hash, 0, $zeros);
	if ( $start === $lead )
	{
		echo "<br/>Success! Puzzle solved with nonce = $nonce $end";
		echo "Try #" . number_format($nonce) . ": Hash(\"$transaction.$nonce\")=$hash $end";
		break;
	}
	elseif ($details == "yes") echo "Try #" . number_format($nonce) . ": Hash(\"$transaction.$nonce\")=$hash $end";
}

if ($nonce == $maxTries + 1) echo "Puzzle not solved with ". number_format($maxTries) . " tries.<br/>\n";
echo "<br/>Seconds to Execute: " . (microtime(true) - $_SERVER["REQUEST_TIME_FLOAT"]) . $end;
echo "<br/><a href=\"puzzle.php?transaction=".$_GET['transaction']."&zeros=".$_GET['zeros']."&details=".$_GET['details']."\">Try Again</a>$end";
?>
